#include <iostream>
#include <algorithm>
using namespace std;

typedef long long ll;

const int B = 63;
const int maxn = 1005;

int n, m;
int sum[maxn][maxn];

ll sol;
ll bits[maxn][maxn];

int next_checkpoint(int x) {
    return min(B * ((x - 1) / B) + B, n);
}

int main() {
    ios::sync_with_stdio(false);
    cin >> n >> m;
    for (int i = 1; i <= n; i++) {
        for (int j = 1; j <= m; j++) {
            int x;
            cin >> x;
            sum[i][j] = x + sum[i - 1][j] + sum[i][j - 1] - sum[i - 1][j - 1];
            bits[next_checkpoint(i)][j] |= (ll)sum[i][j] % 2 << (next_checkpoint(i) - i);
        }   
    }
    for (int l = 1; l <= m; l++)
        for (int r = l; r <= m; r++) {
            int prev[2] = {1, 0};
            int i = 1;
            do {
                i = next_checkpoint(i);
                ll current_bits = bits[i][r] ^ bits[i][l - 1];
                int curr_ones = __builtin_popcountll(current_bits);
                int curr_size = i % B == 0 ? B : i % B;
                int curr[2] = {curr_size - curr_ones, curr_ones};
                sol += curr[0] * prev[0] + curr[1] * prev[1];
                sol += curr[0] * (curr[0] - 1) / 2;
                sol += curr[1] * (curr[1] - 1) / 2;
                prev[0] += curr[0];
                prev[1] += curr[1];
                i++;
            } 
            while (i <= n);
        }
    cout << sol << endl;
    return 0;
}
